<?php
require 'koneksi.php';
require_once("dompdf/autoload.inc.php");

use Dompdf\Dompdf;
use Dompdf\Options;

// **Konfigurasi Dompdf**
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$options->set('defaultFont', 'Arial');
$options->set('isPhpEnabled', true);
$options->set('isFontSubsettingEnabled', true);

$dompdf = new Dompdf($options);

// **Ambil Data dari Database**
$bobot = query("SELECT * FROM bobot2")[0];
$nilai_alternatif = query("SELECT * FROM channel ORDER BY id");  // Urutkan berdasarkan nama channel
$hasil_vektor_s = query("SELECT * FROM vektors2 ORDER BY id");  // Urutkan berdasarkan nama channel
$hasil_vektor_v = query("SELECT * FROM hasil2 ORDER BY id_hasil");  // Urutkan berdasarkan nama channel
$ranking = query("SELECT * FROM hasil2 ORDER BY nilai DESC");

// **Cek apakah data ada**
if (empty($bobot) || empty($nilai_alternatif) || empty($hasil_vektor_s) || empty($hasil_vektor_v)) {
    die("Data tidak tersedia! Pastikan tabel `bobot2`, `input_nilai2`, `vektors2`, dan `hasil2` sudah diisi.");
}

// **Hitung total bobot**
$jumlah_bobot = array_sum($bobot);
if ($jumlah_bobot == 0) {
    die("Bobot tidak boleh nol! Periksa kembali bobot yang diinput.");
}

// **Normalisasi Bobot**
$w = [];
foreach ($bobot as $key => $value) {
    if ($key != 'id_bobot2') {
        $w[$key] = $value / $jumlah_bobot;
    }
}

// **Total Vektor S & V**
$total_s = array_sum(array_column($hasil_vektor_s, 'nilai'));
$total_v = array_sum(array_column($hasil_vektor_v, 'nilai'));

// **Tanggal otomatis**
$tanggal = date("d-m-Y");

// **Struktur HTML untuk PDF**
$html = '<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .table1 {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
        }
        .table1, th, td {
            border: 1px solid #000;
            padding: 5px;
            font-size: 10px;
        }
        h2, p {
            text-align: center;
        }
        h3 {
            text-decoration: underline;
            text-align: center;
        }
        h1 {
            text-align: center;
            font-size: 22px;
        }
    </style>
</head>
<body>

    <br>
    <h1>Laporan Hasil Rekomendasi Channel YouTube Terbaik sebagai Media Pembelajaran Mahasiswa Teknik Informatika dengan Metode Weighted Product</h1>
    <br>
    <h2>Nusa Putra University</h2>
    <p>Sukabumi - Bogor - Jawa Barat - Indonesia</p>
    <p>Date: ' . htmlspecialchars($tanggal) . '</p>
<hr style="border: 2px solid black;" />

    <br><br>';

// **Tabel Bobot Kriteria**
$html .= '<h3>Data Bobot Kriteria</h3>
<table class="table1">
<tr>
    <th>Kriteria</th>
    <th>Bobot</th>
    <th>Bobot Normalisasi</th>
</tr>';

foreach ($w as $key => $value) {
    $html .= '<tr>
        <td>' . strtoupper($key) . '</td>
        <td>' . intval($bobot[$key]) . '</td>  <!-- Tanpa desimal -->
        <td>' . number_format($value, 6) . '</td>  <!-- Tampilkan 6 angka desimal -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Nilai Alternatif**
$html .= '<h3>Data Nilai Alternatif</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Nama Channel</th>
    <th>C1</th>
    <th>C2</th>
    <th>C3</th>
    <th>C4</th>
    <th>C5</th>
</tr>';

$no = 1;
foreach ($nilai_alternatif as $alt) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($alt["nama"]) . '</td>
        <td>' . intval($alt["c1"]) . '</td>  <!-- Tanpa desimal -->
        <td>' . intval($alt["c2"]) . '</td>
        <td>' . intval($alt["c3"]) . '</td>
        <td>' . intval($alt["c4"]) . '</td>
        <td>' . intval($alt["c5"]) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Vektor S**
$html .= '<h3>Hasil Vektor S</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternatif</th>
    <th>Nilai Vektor S</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_s as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Tampilkan 6 angka desimal -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Nilai Vektor S : " . number_format($total_s, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Vektor V**
$html .= '<h3>Hasil Vektor V</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternatif</th>
    <th>Nilai Vektor V</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_v as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Tampilkan 6 angka desimal -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Nilai Vektor V : " . number_format($total_v, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Perankingan**
$html .= '<h3>Hasil Perankingan</h3>
<table class="table1">
<tr>
    <th>Peringkat</th>
    <th>Nama Channel</th>
    <th>Nilai</th>
</tr>';

$no = 1;
foreach ($ranking as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Tampilkan 6 angka desimal -->
    </tr>';
}
$html .= '</table><br><br>';

// **Tutup HTML**
$html .= "</body></html>";

// **Proses PDF dengan Dompdf**
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream('Laporan_Evaluasi_Channel_YouTube.pdf', array("Attachment" => 0));
?>
